<?php
/** Plantilla single para Shoplite Producto (compatible con temas clásicos y FSE) */
if (!defined('ABSPATH')) exit;

// ¿El tema realmente tiene header.php / footer.php?
$theme_has_header = function_exists('get_theme_file_path') && file_exists( get_theme_file_path('header.php') );
$theme_has_footer = function_exists('get_theme_file_path') && file_exists( get_theme_file_path('footer.php') );

// ----- Apertura -----
if ( $theme_has_header ) {
  get_header(); // usa el header del tema (no hay avisos)
} else {
  ?><!doctype html>
  <html <?php language_attributes(); ?>>
  <head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! did_action('wp_head') ) wp_head(); ?>
  </head>
  <body <?php body_class('shoplite-standalone'); ?>>
  <?php
}

echo '<main class="shoplite-single-product" style="max-width:980px;margin:40px auto;padding:0 16px;">';

while ( have_posts() ) : the_post();
  $pid    = get_the_ID();
  $nombre = get_the_title();
  $img    = get_the_post_thumbnail_url($pid, 'large');
  $price  = (float) get_post_meta($pid, '_tb_price', true);
  $fisico = (get_post_meta($pid, '_tb_is_physical', true) === '1');
  $envio  = (float) get_post_meta($pid, '_tb_shipping_cost', true);

  $nonce_key = defined('SHOPLITE_NONCE_CART_ACTION') ? SHOPLITE_NONCE_CART_ACTION : 'shoplite_cart_action';
  $nonce     = wp_create_nonce($nonce_key);
  $action    = get_permalink($pid);

  $estilo   = function_exists('shoplite_get_button_style') ? shoplite_get_button_style() : 'clasico';
  $btn_attr = function_exists('ts_get_btn_style_attr') ? ts_get_btn_style_attr() : '';
  ?>
  <article class="producto">
    <header style="margin-bottom:18px;">
      <h1 style="margin:0;"><?php echo esc_html($nombre); ?></h1>
    </header>

    <div class="producto-grid" style="display:grid;grid-template-columns:1fr 1fr;gap:24px;">
      <div class="producto-media">
        <?php if ($img): ?>
          <img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr($nombre); ?>" style="width:100%;height:auto;border-radius:12px;"/>
        <?php else: ?>
          <div style="aspect-ratio:16/10;background:#f2f2f2;border-radius:12px;display:flex;align-items:center;justify-content:center;color:#999;">
            <?php esc_html_e('No image','shoplite'); ?>
          </div>
        <?php endif; ?>
      </div>

      <div class="producto-info">
        <div class="producto-precio" style="font-size:1.8rem;font-weight:700;margin:6px 0 12px;">
          €<?php echo esc_html(number_format($price, 2)); ?>
        </div>

        <?php if ($fisico && $envio > 0): ?>
          <div style="margin-bottom:10px;opacity:.8;">
            <?php printf(esc_html__('Shipping: €%s','shoplite'), esc_html(number_format($envio,2))); ?>
          </div>
        <?php endif; ?>

        <?php if (has_excerpt()): ?>
          <div class="producto-excerpt" style="margin:12px 0 16px;opacity:.9;"><?php the_excerpt(); ?></div>
        <?php endif; ?>

        <form method="get" action="<?php echo esc_url($action); ?>"
              class="producto-comprar" style="display:flex;gap:10px;align-items:center;margin:16px 0 22px;">
          <label for="qty-<?php echo esc_attr($pid); ?>" class="screen-reader-text">
            <?php esc_html_e('Quantity','shoplite'); ?>
          </label>

          <input type="number" id="qty-<?php echo esc_attr($pid); ?>" name="qty" value="1" min="1" step="1"
                 style="width:84px;padding:8px;border:1px solid #ddd;border-radius:8px;"/>

          <input type="hidden" name="add_to_cart" value="<?php echo esc_attr('tbp_'.$pid); ?>">
          <input type="hidden" name="_wpnonce"    value="<?php echo esc_attr($nonce); ?>">

          <button type="submit" <?php echo $btn_attr; ?> class="boton-tienda <?php echo esc_attr($estilo); ?> tb-add">
            <?php echo esc_html(function_exists('ts_get_btn_text') ? ts_get_btn_text('cart') : get_option('ts_btn_text_cart','Add to cart')); ?>
          </button>
        </form>

        <div class="producto-desc" style="line-height:1.7;"><?php the_content(); ?></div>
      </div>
    </div>
  </article>
  <?php
endwhile;

echo '</main>';

// ----- Cierre -----
if ( $theme_has_footer ) {
  get_footer();
} else {
  if ( ! did_action('wp_footer') ) wp_footer();
  ?></body></html><?php
}

