<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * DEBUG (opcional): este archivo se ha cargado correctamente
 * Quita este log cuando termines de probar.
 */
// error_log( '[shoplite] admin-locale.php cargado' );

/**
 * Idiomas disponibles para el backend de Shoplite.
 */
$shoplite_admin_locales = array(
    'es_ES' => array(
        'label' => 'Español',
        'flag'  => '🇪🇸',
    ),
    'en_US' => array(
        'label' => 'English',
        'flag'  => '🇺🇸',
    ),
    'fr_FR' => array(
        'label' => 'Français',
        'flag'  => '🇫🇷',
    ),
    'it_IT' => array(
        'label' => 'Italiano',
        'flag'  => '🇮🇹',
    ),
    'de_DE' => array(
        'label' => 'Deutsch',
        'flag'  => '🇩🇪',
    ),
    'pt_PT' => array(
        'label' => 'Português',
        'flag'  => '🇵🇹',
    ),
    'tr_TR' => array(
        'label' => 'Türçe',
        'flag'  => '🇹🇷',
    ),
);

/**
 * Base path for Shoplite (base plugin) languages.
 * More robust than using "../".
 */
function shoplite_lang_base_path() {
    // This file is /shoplite/includes/shoplite-admin-locale.php
    // dirname(__FILE__) says ".../shoplite/includes"
    // plugin_dir_path(dirname(__FILE__)) => ".../shoplite/"
    return plugin_dir_path( dirname( __FILE__ ) ) . 'languages/';
}

/**
 * Base path for Shoplite Pro languages.
 */
function shoplite_pro_lang_base_path() {
    return WP_PLUGIN_DIR . '/shoplite-pro/languages/';
}

/**
 * Get allowed locales list (from the locales array keys).
 */
function shoplite_get_allowed_locales() {
    global $shoplite_admin_locales;
    return array_keys( $shoplite_admin_locales );
}

/**
 * Filter locales: show only languages with an existing Shoplite base .mo
 * (except en_US which is the base/fallback).
 *
 * Note: we only filter by base plugin here. When Shoplite Pro has .mo files,
 * you can tighten this to require both base+pro translations if desired.
 */
function shoplite_filter_locales_by_mo() {
    global $shoplite_admin_locales;

    // Safety: ensure we have an array before array_keys()
    if ( ! is_array( $shoplite_admin_locales ) || empty( $shoplite_admin_locales ) ) {
        $shoplite_admin_locales = array( 'en_US' => 'English (United States)' );
        return;
    }

    $base = shoplite_lang_base_path();

    foreach ( array_keys( $shoplite_admin_locales ) as $code ) {
        if ( $code === 'en_US' ) {
            continue;
        }

        if ( ! file_exists( $base . 'shoplite-' . $code . '.mo' ) ) {
            unset( $shoplite_admin_locales[ $code ] );
        }
    }
}
shoplite_filter_locales_by_mo();


/**
 * Get current user Shoplite locale (stored in user_meta).
 */
function shoplite_get_user_shoplite_locale( $user_id ) {
    $locale = get_user_meta( $user_id, 'shoplite_language', true );
    $locale = is_string( $locale ) ? trim( $locale ) : '';
    return $locale;
}

/**
 * Resolve locale for admin Shoplite translations (with fallback).
 */
function shoplite_resolve_admin_locale() {

    $allowed = shoplite_get_allowed_locales();

    $user_id = get_current_user_id();
    $locale  = $user_id ? shoplite_get_user_shoplite_locale( $user_id ) : '';
    $locale  = is_string( $locale ) ? trim( $locale ) : '';

    if ( ! in_array( $locale, $allowed, true ) ) {
        $locale = 'en_US';
    }

    return $locale;
}

/**
 * Force-load MO files in wp-admin based on per-user setting (shoplite_language).
 * This makes Shoplite independent from WordPress admin language.
 */
function shoplite_force_admin_textdomain() {

    if ( ! is_admin() ) {
        return;
    }

    $locale = shoplite_resolve_admin_locale();

    // Unload first so switching language actually takes effect immediately
    if ( function_exists( 'unload_textdomain' ) ) {
        unload_textdomain( 'shoplite' );
        unload_textdomain( 'tienda-basica' );
        unload_textdomain( 'shoplite-pro' );
    }

    // --- Shoplite (base) ---
    $base = shoplite_lang_base_path();

    $shoplite_mo = $base . 'shoplite-' . $locale . '.mo';
    if ( ! file_exists( $shoplite_mo ) ) {
        // en_US often has no .mo (because strings are already English),
        // but we keep the fallback anyway.
        $shoplite_mo = $base . 'shoplite-en_US.mo';
    }
    if ( file_exists( $shoplite_mo ) ) {
        load_textdomain( 'shoplite', $shoplite_mo );
    }

    // --- Legacy domain (optional) ---
    $legacy_mo = $base . 'tienda-basica-' . $locale . '.mo';
    if ( ! file_exists( $legacy_mo ) ) {
        $legacy_mo = $base . 'tienda-basica-en_US.mo';
    }
    if ( file_exists( $legacy_mo ) ) {
        load_textdomain( 'tienda-basica', $legacy_mo );
    }

    // --- Shoplite Pro (text-domain: shoplite-pro) ---
    // This will start working as soon as you create:
    //   shoplite-pro-es_ES.mo, shoplite-pro-fr_FR.mo, etc.
    $pro_base = shoplite_pro_lang_base_path();

    $pro_mo = $pro_base . 'shoplite-pro-' . $locale . '.mo';
    if ( ! file_exists( $pro_mo ) ) {
        $pro_mo = $pro_base . 'shoplite-pro-en_US.mo';
    }
    if ( file_exists( $pro_mo ) ) {
        load_textdomain( 'shoplite-pro', $pro_mo );
    }

    /**
     * DEBUG (opcional): confirma qué idioma intenta cargar.
     * Quita este log cuando termines de probar.
     */
    // error_log( '[shoplite] force_admin_textdomain locale=' . $locale . ' base_mo=' . ( file_exists( $shoplite_mo ) ? 'yes' : 'no' ) . ' pro_mo=' . ( file_exists( $pro_mo ) ? 'yes' : 'no' ) );
}
add_action( 'plugins_loaded', 'shoplite_force_admin_textdomain', 0 );

/**
 * Handle language selector POST (per-user).
 * Saves preference ONLY for Shoplite; does not touch WordPress global language.
 */
function shoplite_handle_admin_lang_post() {

    global $shoplite_admin_locales;

    if ( ! is_admin() ) {
        return;
    }

    if ( empty( $_POST['shoplite_admin_lang'] ) ) {
        return;
    }

    if (
        ! isset( $_POST['shoplite_lang_nonce'] )
        || ! wp_verify_nonce( $_POST['shoplite_lang_nonce'], 'shoplite_change_admin_lang' )
    ) {
        return;
    }

    $locale = sanitize_text_field( wp_unslash( $_POST['shoplite_admin_lang'] ) );

    // Validate selected locale (must be available in the selector list)
    if ( ! isset( $shoplite_admin_locales[ $locale ] ) ) {
        return;
    }

    $user_id = get_current_user_id();
    if ( ! $user_id ) {
        return;
    }

    update_user_meta( $user_id, 'shoplite_language', $locale );
    update_user_meta( $user_id, 'shoplite_admin_locale', $locale ); // optional legacy key

    // Redirect to avoid form resubmission
    $redirect = remove_query_arg( array( 'shoplite_lang_updated' ) );
    $redirect = add_query_arg( 'shoplite_lang_updated', '1', $redirect );

    wp_safe_redirect( $redirect );
    exit;
}
add_action( 'admin_init', 'shoplite_handle_admin_lang_post' );

/**
 * Render language selector notice in wp-admin (only for current user and only for Shoplite).
 */
function shoplite_render_admin_language_selector() {

    global $shoplite_admin_locales;

    if ( ! is_admin() ) {
        return;
    }

    $user_id = get_current_user_id();
    if ( ! $user_id ) {
        return;
    }

    $current = shoplite_get_user_shoplite_locale( $user_id );

    // If missing/invalid, fallback to user's WP locale, then to en_US.
    if ( empty( $current ) || ! isset( $shoplite_admin_locales[ $current ] ) ) {
        $current = get_user_locale( $user_id );
        if ( ! isset( $shoplite_admin_locales[ $current ] ) ) {
            $current = 'en_US';
        }
    }

    ?>
    <div class="notice notice-info"
         style="margin-top:10px;padding:6px 12px;display:flex;align-items:center;justify-content:space-between;gap:12px;">
        <div>
            <strong><?php esc_html_e( 'Shoplite language (only for you):', 'shoplite' ); ?></strong>
        </div>
        <div>
            <form method="post" style="margin:0;display:inline-flex;align-items:center;gap:6px;">
                <?php wp_nonce_field( 'shoplite_change_admin_lang', 'shoplite_lang_nonce' ); ?>
                <label for="shoplite-admin-lang" style="margin-right:4px;">
                    <?php esc_html_e( 'Language', 'shoplite' ); ?>:
                </label>
                <select id="shoplite-admin-lang" name="shoplite_admin_lang"
                        onchange="this.form.submit();" style="min-width: 140px;">
                    <?php foreach ( $shoplite_admin_locales as $code => $data ) : ?>
                        <option value="<?php echo esc_attr( $code ); ?>" <?php selected( $current, $code ); ?>>
                            <?php echo esc_html( $data['flag'] . ' ' . $data['label'] ); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
        </div>
    </div>
    <?php
}
add_action( 'admin_notices', 'shoplite_render_admin_language_selector' );


