<?php
if (!defined('ABSPATH')) exit;

/**
 * === Sanitización y escape reutilizables ===
 * Mantén este archivo libre de dependencias de UI.
 */

/** Normaliza un pid a partir de 'tbp_123' o '123' */
if (!function_exists('shoplite_pid_from_raw')) {
  function shoplite_pid_from_raw($raw){
    $raw = is_string($raw) ? sanitize_text_field( wp_unslash($raw) ) : $raw;
    if (is_string($raw) && preg_match('/^tbp_(\d+)$/', $raw, $m)) {
      return (int) $m[1];
    }
    return absint($raw);
  }
}

/** Cantidad >= 1 */
if (!function_exists('shoplite_clean_qty')) {
  function shoplite_clean_qty($v){
    $v = is_string($v) ? sanitize_text_field( wp_unslash($v) ) : $v;
    $n = (int) $v;
    return ($n > 0) ? $n : 1;
  }
}

/** Limpia array de cantidades tipo qty[key] => int>=1 */
if (!function_exists('shoplite_clean_qty_array')) {
  function shoplite_clean_qty_array($arr){
    $out = [];
    if (!is_array($arr)) return $out;
    foreach ($arr as $k => $v) {
      // claves aceptadas: 'tbp_123' o '123'
      $kk = is_string($k) ? sanitize_key($k) : (string) absint($k);
      if (!preg_match('/^(tbp_\d+|\d+)$/', $kk)) continue;
      $out[$kk] = shoplite_clean_qty($v);
    }
    return $out;
  }
}

/** Limpia una “línea” del carrito */
if (!function_exists('shoplite_clean_cart_line')) {
  function shoplite_clean_cart_line($line){
    $pid = isset($line['id']) ? absint($line['id']) : 0;
    return [
      'id'       => $pid,
      'nombre'   => isset($line['nombre']) ? sanitize_text_field( $line['nombre'] ) : '',
      'precio'   => isset($line['precio']) ? (float) $line['precio'] : 0.0,
      'cantidad' => isset($line['cantidad']) ? shoplite_clean_qty($line['cantidad']) : 1,
      'fisico'   => !empty($line['fisico']) ? 1 : 0,
      'envio'    => isset($line['envio']) ? (float) $line['envio'] : 0.0,
    ];
  }
}

/** KSES: HTML permitido en textos “seguros” del plugin (descripciones cortas, etc.) */
if (!function_exists('shoplite_allowed_html')) {
  function shoplite_allowed_html(){
    return [
      'a'      => ['href'=>[], 'title'=>[], 'target'=>[], 'rel'=>[]],
      'br'     => [],
      'em'     => [],
      'strong' => [],
      'p'      => ['class'=>[]],
      'ul'     => ['class'=>[]],
      'ol'     => ['class'=>[]],
      'li'     => ['class'=>[]],
      'span'   => ['class'=>[]],
    ];
  }
}

/** Formatea dinero con i18n (no escapa: escapa en el punto de salida) */
if (!function_exists('shoplite_money')) {
  function shoplite_money($float){
    return number_format_i18n( (float)$float, 2 );
  }
}
