<?php
if ( ! defined('ABSPATH') ) exit;

add_action('shoplite_order_paid', 'shoplite_inventory_reduce_stock_on_paid', 5, 1);

function shoplite_inventory_reduce_stock_on_paid( $order_id ) {
    $order_id = (int) $order_id;
    if ( $order_id <= 0 ) return;

    // Idempotencia
    if ( get_post_meta( $order_id, '_shoplite_stock_reduced', true ) === '1' ) {
        return;
    }

    $raw = get_post_meta( $order_id, '_shoplite_order_items', true );
    if ( empty($raw) ) {
        // Nada que descontar, marcamos como hecho para evitar loops
        update_post_meta( $order_id, '_shoplite_stock_reduced', '1' );
        return;
    }

    $items = is_string($raw) ? json_decode($raw, true) : $raw;
    if ( ! is_array($items) ) {
        update_post_meta( $order_id, '_shoplite_stock_issue', '1' );
        return;
    }

    // Normalizar: acumular qty por product_id
    $need = []; // [product_id => qty]
    foreach ( $items as $k => $it ) {
        if ( ! is_array($it) ) continue;

        $qty = isset($it['qty']) ? (int)$it['qty'] : ( isset($it['cantidad']) ? (int)$it['cantidad'] : 1 );
        $qty = max(1, $qty);

        $pid = isset($it['product_id']) ? (int)$it['product_id'] : 0;

        if ( $pid <= 0 && is_string($k) && preg_match('/^tbp_(\d+)$/', (string)$k, $m) ) {
            $pid = (int)$m[1];
        }

        if ( $pid <= 0 ) continue;

        if ( ! isset($need[$pid]) ) $need[$pid] = 0;
        $need[$pid] += $qty;
    }

    if ( empty($need) ) {
        update_post_meta( $order_id, '_shoplite_stock_reduced', '1' );
        return;
    }

    // Descontar con seguridad
    foreach ( $need as $pid => $qty ) {

        $manage = get_post_meta( (int)$pid, '_sl_manage_stock', true );
        if ( $manage !== '1' ) continue;

        $stock = (int) get_post_meta( (int)$pid, '_sl_stock_qty', true );

        if ( $stock < (int)$qty ) {
            // Oversell o manipulación: marcar incidencia y salir (no seguir entregas)
            update_post_meta( $order_id, '_shoplite_stock_issue', '1' );
            if ( defined('WP_DEBUG') && WP_DEBUG && function_exists('error_log') ) {
                error_log('[shoplite][INVENTORY] stock insufficient on paid. order=' . $order_id . ' pid=' . $pid . ' need=' . $qty . ' stock=' . $stock);
            }
            return;
        }

        update_post_meta( (int)$pid, '_sl_stock_qty', (string) ( $stock - (int)$qty ) );
    }

    update_post_meta( $order_id, '_shoplite_stock_reduced', '1' );
}
