<?php
// Fallback in case someone includes this file directly before the main plugin.
if (!defined('SHOPLITE_NONCE_CART'))        define('SHOPLITE_NONCE_CART',        'shoplite_cart');
if (!defined('SHOPLITE_NONCE_CART_ACTION')) define('SHOPLITE_NONCE_CART_ACTION', 'shoplite_cart_action');
if (!defined('SHOPLITE_NONCE_PAYPAL'))      define('SHOPLITE_NONCE_PAYPAL',      'shoplite_paypal_nonce');
if (!defined('SHOPLITE_NONCE_STRIPE'))      define('SHOPLITE_NONCE_STRIPE',      'shoplite_stripe_nonce');


// === Button text helpers
if ( ! function_exists('ts_get_btn_text') ) {
  function ts_get_btn_text( $which = 'buy' ) {
    switch ($which) {
      case 'cart':     return get_option('ts_btn_text_cart',     'Add to cart');
      case 'checkout': return get_option('ts_btn_text_checkout', 'Checkout');
      case 'empty':    return get_option('ts_btn_text_empty',    'Empty cart');
      case 'update':   return get_option('ts_btn_text_update',   'Update quantities');
      case 'remove':   return get_option('ts_btn_text_remove',   'Remove');
      case 'buy':
      default:
        $legacy = get_option('ts_btn_text',''); // compatibility with old option
        return get_option('ts_btn_text_buy', $legacy !== '' ? $legacy : 'Buy');
    }
  }
}

// === Inline style helper based on options
if ( ! function_exists('ts_get_btn_style_attr') ) {
  function ts_get_btn_style_attr() {
    $color  = get_option('ts_btn_color', '#2ea44f');
    $radius = (int) get_option('ts_btn_radius', 6);
    $fs     = (int) get_option('ts_btn_font_size', 16);
    $style  = sprintf(
      'style="background:%s;border-radius:%dpx;font-size:%dpx;color:#fff"',
      esc_attr($color), $radius, $fs
    );
    return $style;
  }
}

// …your other helpers above

// === Render buttons with backend text/style
if ( ! function_exists('ts_btn') ) {
  /**
   * ts_btn('buy'|'cart'|'checkout'|'empty'|'update'|'remove', $args)
   * $args:
   *  - tag: 'a' | 'button' | 'input'  (default: 'a')
   *  - href: URL (if tag === 'a')
   *  - class: extra classes
   *  - attrs: array of extra attributes (name, value, data-*, type, form, etc.)
   *
   * Returns the HTML for the button (use echo if you want to print it).
   */
  function ts_btn( $type, $args = [] ){
    $defaults = ['tag' => 'a', 'href' => '#', 'class' => '', 'attrs' => []];
    $args = wp_parse_args($args, $defaults);

    $text    = ts_get_btn_text($type);
    $style   = ts_get_btn_style_attr();
    $classes = trim('ts-btn ts-btn--'.$type.' '.($args['class'] ?? ''));

    $atts = array_merge(['class'=>$classes], (array)$args['attrs']);
    $html_atts = '';
    foreach ($atts as $k=>$v) {
      if ($v === null) continue;
      $html_atts .= ' '.esc_attr($k).'="'.esc_attr($v).'"';
    }

    if ($args['tag'] === 'button') {
      if (stripos($html_atts, ' type=') === false) $html_atts .= ' type="button"';
      return '<button '.$style.$html_atts.'>'.esc_html($text).'</button>';
    }

    if ($args['tag'] === 'input') {
      if (stripos($html_atts, ' type=') === false) $html_atts .= ' type="submit"';
      return '<input '.$style.$html_atts.' value="'.esc_attr($text).'" />';
    }

    $href = isset($args['href']) ? esc_url($args['href']) : '#';
    return '<a '.$style.' href="'.$href.'"'.$html_atts.'>'.esc_html($text).'</a>';
  }
}

// --- Helpers for "Add to cart" ---

// Returns the numeric ID even if it comes as "tbp_123", "tbp_tbp_123" or 123
if (!function_exists('shoplite_normalize_pid')) {
  function shoplite_normalize_pid($raw) {
    if (is_string($raw) && preg_match('/^(?:tbp_)+(\d+)/', $raw, $m)) {
      return (int) $m[1];
    }
    return (int) $raw;
  }
}

// Builds the correct URL with a single "tbp_" and its nonce
if (!function_exists('shoplite_add_to_cart_url')) {
  function shoplite_add_to_cart_url($raw_id, $page_url = null) {
    $pid   = shoplite_normalize_pid($raw_id);
    $nonce = wp_create_nonce( SHOPLITE_NONCE_CART_ACTION );

    // Use the current URL if none is provided
    if (!$page_url) {
      $page_url = !empty($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : home_url('/');
    }

    return add_query_arg(
      [
        'add_to_cart' => 'tbp_' . $pid,
        '_wpnonce'    => $nonce,
      ],
      $page_url
    );
  }
}
