<?php
if (!defined('ABSPATH')) exit;

/** 1) Funciones antiguas → nuevas */
if (!function_exists('tienda_basica_carrito')) {
  function tienda_basica_carrito() {
    if (defined('WP_DEBUG') && WP_DEBUG) {
      _deprecated_function(__FUNCTION__, '0.2.0', 'shoplite_cart_render');
    }
    return function_exists('shoplite_cart_render') ? shoplite_cart_render() : '';
  }
}

/** 2) Shortcode antiguo → nuevo */
add_shortcode('tienda_basica', function($atts = []) {
  if (defined('WP_DEBUG') && WP_DEBUG) {
    _deprecated_function('[tienda_basica]', '0.2.0', '[shoplite_cart]');
  }
  return do_shortcode('[shoplite_cart]');
});

/** 3) Hooks/AJAX antiguos → handler nuevo */
add_action('admin_post_nopriv_tienda_basica_cart', 'shoplite_handle_cart_post');
add_action('admin_post_tienda_basica_cart',        'shoplite_handle_cart_post');

// (Si tenías AJAX antiguos, añade alias aquí hacia sus equivalentes nuevos)
// add_action('wp_ajax_tienda_basica_algo',     'shoplite_ajax_algo');
// add_action('wp_ajax_nopriv_tienda_basica_algo', 'shoplite_ajax_algo');
