<?php
// includes/class-shoplite-updater.php
if ( ! defined('ABSPATH') ) exit;

class Shoplite_Updater {
  public static function init(){
    add_filter('pre_set_site_transient_update_plugins', [__CLASS__,'check_update']);
    add_filter('plugins_api', [__CLASS__,'plugin_info'], 20, 3);
  }

  public static function check_update($transient){
    if ( empty($transient->checked) || empty(SHOPLITE_UPDATE_URL) ) return $transient;

    $key = get_option('shoplite_license_key','');
    $domain = home_url();

    $url = add_query_arg([
      'key'    => rawurlencode($key),
      'domain' => rawurlencode($domain),
    ], SHOPLITE_UPDATE_URL);

    $resp = wp_remote_get($url, ['timeout'=>20]);
    if ( is_wp_error($resp) ) return $transient;

    $data = json_decode(wp_remote_retrieve_body($resp), true);
    if ( empty($data['version']) || empty($data['download_url']) ) return $transient;

    // Cambia a tu archivo real principal si es distinto
    $plugin_file = plugin_basename( SHOPLITE_PLUGIN_FILE ); // normalmente shoplite/shoplite.php

    if ( version_compare($data['version'], self::current_version(), '>') ) {
      $obj = new stdClass();
      $obj->slug        = 'shoplite-pro';
      $obj->plugin      = $plugin_file;
      $obj->new_version = $data['version'];
      $obj->package     = $data['download_url']; // ZIP protegido por licencia
      $obj->tested      = $data['tested']  ?? '';
      $obj->requires    = $data['requires']?? '';
      $transient->response[$plugin_file] = $obj;
    } else {
      $transient->no_update[$plugin_file] = (object)[
        'slug'=>'shoplite-pro','new_version'=>$data['version']
      ];
    }
    return $transient;
  }

  public static function plugin_info($res, $action, $args){
    if ($action !== 'plugin_information' || ($args->slug ?? '') !== 'shoplite-pro') return $res;

    $key = get_option('shoplite_license_key','');
    $domain = home_url();
    $url = add_query_arg(['key'=>$key,'domain'=>$domain,'info'=>1], SHOPLITE_UPDATE_URL);
    $resp = wp_remote_get($url, ['timeout'=>20]);
    if ( is_wp_error($resp) ) return $res;

    $data = json_decode(wp_remote_retrieve_body($resp), true);
    if (empty($data)) return $res;

    $res = (object)[
      'name'        => 'Shoplite Pro',
      'version'     => $data['version'] ?? self::current_version(),
      'sections'    => ['description' => $data['changelog'] ?? ''],
      'download_link'=> $data['download_url'] ?? '',
    ];
    return $res;
  }

  private static function current_version(){
    // intenta leer versión del header del plugin
    $data = get_file_data(SHOPLITE_PLUGIN_FILE, ['Version'=>'Version'], 'plugin');
    return $data['Version'] ?: '1.0.0';
  }
}
