<?php
defined( 'ABSPATH' ) || exit;

/**
 * Strict sanitizer: only allow en_US / es_ES.
 */
function shoplite_sanitize_lang_locale( $value ) {
    $allowed = array( 'en_US', 'es_ES' );

    $value = is_string( $value ) ? trim( $value ) : '';
    if ( ! in_array( $value, $allowed, true ) ) {
        $value = 'en_US';
    }

    return $value;
}

/**
 * Register Shoplite language setting inside the existing Appearance settings group/page.
 *
 * Group: shoplite_appearance_group
 * Page:  shoplite-appearance
 */
function shoplite_register_language_setting() {

    // Register option (saved in wp_options as shoplite_lang)
    register_setting(
        'shoplite_appearance_group',
        'shoplite_lang',
        array(
            'type'              => 'string',
            'sanitize_callback' => 'shoplite_sanitize_lang_locale',
            'default'           => 'en_US',
        )
    );

    // New section just for language (no need to depend on your existing section IDs)
    add_settings_section(
        'shoplite_language_section',
        __( 'Language', 'shoplite' ),
        'shoplite_language_section_cb',
        'shoplite-appearance'
    );

    // Field (dropdown)
    add_settings_field(
        'shoplite_lang',
        __( 'Plugin language', 'shoplite' ),
        'shoplite_render_lang_field',
        'shoplite-appearance',
        'shoplite_language_section'
    );
}
add_action( 'admin_init', 'shoplite_register_language_setting' );

function shoplite_language_section_cb() {
    echo '<p>' . esc_html__( 'This controls only Shoplite’s language, independent of WordPress.', 'shoplite' ) . '</p>';
}

function shoplite_render_lang_field() {
    $current = get_option( 'shoplite_lang', 'en_US' );

    $choices = array(
        'en_US' => __( 'English', 'shoplite' ),
        'es_ES' => __( 'Español', 'shoplite' ),
    );

    if ( ! isset( $choices[ $current ] ) ) {
        $current = 'en_US';
    }

    echo '<select name="shoplite_lang" id="shoplite_lang">';
    foreach ( $choices as $locale => $label ) {
        printf(
            '<option value="%s"%s>%s</option>',
            esc_attr( $locale ),
            selected( $current, $locale, false ),
            esc_html( $label )
        );
    }
    echo '</select>';
}
