<?php
namespace TuPlugin\Rest;

use WP_REST_Controller;
use WP_REST_Server;
use WP_REST_Request;
use WP_REST_Response;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Rest_Bizum_Controller extends WP_REST_Controller {
    public function __construct() {
        $this->namespace = 'tuplugin/v1';
        $this->rest_base = 'payments/bizum';
    }

    public function register_routes() {
        register_rest_route( $this->namespace, '/' . $this->rest_base . '/create', [
            [
                'methods'  => WP_REST_Server::CREATABLE,
                'callback' => [ $this, 'create_payment' ],
                'permission_callback' => '__return_true',
                'args' => [
                    'amount' => [ 'required' => true ],
                    'currency' => [ 'required' => true ],
                    'order_id' => [ 'required' => false ],
                ],
            ],
        ]);

        register_rest_route( $this->namespace, '/' . $this->rest_base . '/webhook', [
            [
                'methods'  => WP_REST_Server::CREATABLE,
                'callback' => [ $this, 'handle_webhook' ],
                'permission_callback' => '__return_true',
            ],
        ]);
    }

    public function create_payment( WP_REST_Request $request ) {
        // TODO: implementar lógica real Bizum/Redsys
        $merchantOrderId = 'MERCH-' . time() . '-' . wp_rand(1000,9999);
        return new WP_REST_Response( [
            'status' => 'pending',
            'merchantOrderId' => $merchantOrderId,
            'message' => __( 'Bizum creation skeleton. Implementation pending.', 'shoplite' ),
        ], 200 );
    }

    public function handle_webhook( WP_REST_Request $request ) {
        // TODO: validar firma + actualizar estado de pedido
        return new WP_REST_Response( [
            'ok' => true,
            'message' => __( 'Bizum webhook received (skeleton). Implementation pending.', 'shoplite' ),
        ], 200 );
    }
}
