<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class WC_Gateway_TUP_Bizum extends WC_Payment_Gateway {

    public function __construct() {
        $this->id                 = 'tup_bizum'; // Debe coincidir con $name en la clase de Blocks
        $this->method_title       = __( 'Bizum (Shoplite)', 'shoplite' );
        $this->method_description = __( 'Bizum payment via POS (skeleton).', 'shoplite' );
        $this->has_fields         = false;

        $this->init_form_fields();
        $this->init_settings();

        $this->enabled = $this->get_option( 'enabled', 'no' );
        $this->title   = $this->get_option( 'title', __( 'Bizum', 'shoplite' ) );

        // Guardar ajustes desde el admin
        add_action(
            'woocommerce_update_options_payment_gateways_' . $this->id,
            array( $this, 'process_admin_options' )
        );

        // Soportes básicos
        $this->supports = array( 'products' );
    }

    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                'title'   => __( 'Enable/Disable', 'shoplite' ),
                'type'    => 'checkbox',
                'label'   => __( 'Enable Bizum (esqueleto)', 'shoplite' ),
                'default' => 'no',
            ),
            'title' => array(
                'title'       => __( 'Title', 'shoplite' ),
                'type'        => 'text',
                'default'     => __( 'Bizum', 'shoplite' ),
                'desc_tip'    => true,
                'description' => __( 'Label visible at checkout.', 'shoplite' ),
            ),
        );
    }

    // Proceso de pago temporal (no cobra). Evita finalizar pedido hasta integrar Redsys.
    public function process_payment( $order_id ) {
        wc_add_notice( __( 'Bizum integration in progress. Test method only.', 'shoplite' ), 'error' );
        return array( 'result' => 'failure' );
    }
}
