<?php
namespace TuPlugin\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class BizumPaymentMethod extends AbstractPaymentMethodType {

    protected $name = 'tup_bizum';
    protected $settings = array();

    public function initialize() {
        $this->settings = get_option( 'tup_bizum_settings', array() );
    }

    public function is_active() : bool {
        // Default OFF, and only ON when option is exactly '1'
        // (avoid (bool) casting surprises with '0' strings)
        return get_option( 'tup_enable_bizum', '0' ) === '1';
    }

    public function get_payment_method_script_handles() : array {

        // Intentamos detectar el archivo principal del plugin.
        // Primero el antiguo TUP_PLUGIN_FILE, luego el nuevo SHOPLITE_PLUGIN_FILE, y si no, este mismo archivo.
        $plugin_file = defined( 'TUP_PLUGIN_FILE' )
            ? TUP_PLUGIN_FILE
            : ( defined( 'SHOPLITE_PLUGIN_FILE' ) ? SHOPLITE_PLUGIN_FILE : __FILE__ );

        wp_register_script(
            'tup-bizum-blocks',
            plugins_url( 'assets/js/blocks-bizum.js', $plugin_file ),
            array( 'wc-blocks-registry', 'wc-settings', 'wp-element', 'wp-i18n', 'wp-html-entities' ),
            '1.1.0',
            true
        );

        // 🔁 IMPORTANTE: usar el textdomain correcto del plugin
        wp_set_script_translations(
            'tup-bizum-blocks',
            'shoplite',
            plugin_dir_path( $plugin_file ) . 'languages'
        );

        return array( 'tup-bizum-blocks' );
    }

    public function get_payment_method_data() : array {
        return array(
            'title'       => __( 'Bizum', 'shoplite' ),
            'description' => __( 'Pay with Bizum by confirming in your banking app.', 'shoplite' ),
            'supports'    => array( 'features' => array() ),
            // 🔁 Ajustamos también el namespace REST para que sea consistente con el resto del plugin.
            'createUrl'   => rest_url( 'shoplite/v1/payments/bizum/create' ),
        );
    }
}

