(function (w) {
  // Dependencias globales que expone Woo Blocks
  var wc = w.wc || {};
  var wp = w.wp || {};
  var registry =
    (wc && (wc.wcBlocksRegistry || wc.blocksRegistry)) || // Woo 8/10+
    (w.wcBlocksRegistry) ||                               // fallback
    null;

  if (!registry || !wp.element || !wp.i18n) {
    // Si el registry no existe aún, no hacemos nada (no rompemos la página)
    return;
  }

  var __ = wp.i18n.__;
  var createElement = wp.element.createElement;

  // Datos inyectados desde PHP por AbstractPaymentMethodType (clave: '<name>_data')
  var settings = (wc && wc.wcSettings && wc.wcSettings.getSetting)
    ? wc.wcSettings.getSetting('tup_bizum_data', {})
    : {};

  var BizumContent = function () {
    return createElement(
      'div',
      { className: 'tup-bizum-block' },
      createElement(
        'p',
        null,
        __('Confirm the payment in your Bizum app.', 'shoplite')
      )
    );
  };

  // Registro del método de pago para Checkout de Bloques
  registry.registerPaymentMethod({
    name: 'tup_bizum', // debe coincidir con $name en PHP
    label: __('Bizum', 'shoplite'),
    ariaLabel: __('Pay with Bizum', 'shoplite'),
    content: createElement(BizumContent, null),
    edit: createElement(BizumContent, null),
    canMakePayment: function () {
      return true;
    }, // aquí podrías comprobar país/moneda si quieres
    supports: { features: [] },
    // El flujo real de create/confirm se hará en el endpoint REST cuando lo conectemos
  });
})(window);

