<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Sincroniza tokens (guardados en postmeta por el core) a la tabla wp_shoplite_deliveries (Pro).
 *
 * Hook emitido por el core: do_action('shoplite_digital_tokens_created', $order_id, $created, $customer_email)
 */
add_action( 'shoplite_digital_tokens_created', 'shoplite_pro_sync_deliveries_from_tokens', 10, 3 );

function shoplite_pro_sync_deliveries_from_tokens( $order_id, $tokens, $customer_email ) {
    global $wpdb;

    $order_id = (int) $order_id;
    if ( $order_id <= 0 ) return;

    if ( ! is_array( $tokens ) || empty( $tokens ) ) return;

    $table = $wpdb->prefix . 'shoplite_deliveries';

    // Si el core ya marcó email sent, podemos crear en "delivered". Si no, "pending".
    $email_sent = get_post_meta( $order_id, '_shoplite_delivery_email_sent', true );
    $default_status = ( $email_sent === '1' ) ? 'delivered' : 'pending';

    // Límite por token (tu política actual)
    $downloads_limit = 5;

    foreach ( $tokens as $t ) {
        if ( ! is_array( $t ) ) continue;

        $product_id = isset( $t['product_id'] ) ? (int) $t['product_id'] : 0;
        $token      = isset( $t['token'] ) ? sanitize_text_field( (string) $t['token'] ) : '';
        $url        = isset( $t['url'] ) ? esc_url_raw( (string) $t['url'] ) : '';

        if ( $product_id <= 0 || $token === '' ) {
            continue;
        }

        // Evitar duplicados: si ya existe este token, no insertamos
        $exists = (int) $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$table} WHERE token = %s",
                $token
            )
        );
        if ( $exists > 0 ) {
            continue;
        }

        // delivery_data: guarda lo que ya tienes (url) + si quieres, añade attachment_id desde el producto
        $att_id = (int) get_post_meta( $product_id, '_tb_download_attachment_id', true );
        $delivery_data = wp_json_encode(
            [
                'url'           => $url,
                'attachment_id' => $att_id,
            ],
            JSON_UNESCAPED_SLASHES
        );

        $now = current_time( 'mysql' );

        $wpdb->insert(
            $table,
            [
                'order_id'        => $order_id,
                'product_id'      => $product_id,
                'customer_email'  => (string) $customer_email,
                'delivery_type'   => 'file',
                'status'          => $default_status,
                'token'           => $token,
                'delivery_data'   => $delivery_data,
                'downloads_used'  => 0,
                'downloads_limit' => $downloads_limit,
                'expires_at'      => null,
                'created_at'      => $now,
                'updated_at'      => $now,
            ],
            [
                '%d','%d','%s','%s','%s','%s','%s','%d','%d','%s','%s','%s'
            ]
        );
    }
}
