<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('admin_notices', function () {

    if ( ! current_user_can('manage_options') ) return;
    if ( empty($_GET['shoplite_debug_meta']) ) return;

    $post_id = isset($_GET['post']) ? (int) $_GET['post'] : 0;
    if ( ! $post_id ) return;

    $post = get_post($post_id);
    if ( ! $post ) return;

    $meta = get_post_meta($post_id);

    echo '<div class="notice notice-info"><p><strong>Shoplite debug meta</strong></p>';
    echo '<p>post_id: <strong>' . (int)$post_id . '</strong> | post_type: <strong>' . esc_html($post->post_type) . '</strong></p>';
    echo '<pre style="white-space:pre-wrap;max-height:420px;overflow:auto;">';

    if ( empty($meta) ) {
        echo esc_html("No postmeta found for this post.\n");
    } else {
        foreach ($meta as $k => $vals) {
            echo esc_html($k) . ' => ' . esc_html( print_r($vals, true) ) . "\n";
        }
    }

    echo '</pre></div>';
});
