<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Instalación / migraciones DB de Shoplite Pro
 */
function shoplite_pro_install() {

    // Tablas existentes Pro
    shoplite_pro_install_coupons_tables();
    shoplite_pro_install_abandoned_carts_table();

    // ✅ Tabla de entregas digitales (Pro)
    shoplite_pro_install_deliveries_table();

    // Guarda versión instalada (útil para upgrades)
    if ( defined( 'SHOPLITE_PRO_VERSION' ) ) {
        update_option( 'shoplite_pro_db_version', SHOPLITE_PRO_VERSION );
    }
}

/**
 * Cupones + usos
 */
function shoplite_pro_install_coupons_tables() {
    global $wpdb;

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    $charset_collate = $wpdb->get_charset_collate();

    $table_coupons = $wpdb->prefix . 'shoplite_coupons';
    $table_uses    = $wpdb->prefix . 'shoplite_coupon_uses';

    // Tabla de cupones
    $sql_coupons = "CREATE TABLE $table_coupons (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        internal_name VARCHAR(190) NOT NULL,
        code VARCHAR(64) NOT NULL,
        type VARCHAR(20) NOT NULL,
        amount DECIMAL(10,2) NOT NULL DEFAULT 0,
        starts_at DATETIME NULL,
        ends_at DATETIME NULL,
        max_uses INT NULL,
        max_uses_per_user INT NULL,
        min_cart_total DECIMAL(10,2) NULL,
        product_ids TEXT NULL,
        first_purchase TINYINT(1) NOT NULL DEFAULT 0,
        status VARCHAR(20) NOT NULL DEFAULT 'active',
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY  (id),
        UNIQUE KEY code_unique (code)
    ) $charset_collate;";

    // Tabla de usos de cupones
    $sql_uses = "CREATE TABLE $table_uses (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        coupon_id BIGINT UNSIGNED NOT NULL,
        user_id BIGINT UNSIGNED NULL,
        order_id BIGINT UNSIGNED NULL,
        used_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id),
        KEY coupon_id_idx (coupon_id),
        KEY user_id_idx (user_id),
        KEY order_id_idx (order_id)
    ) $charset_collate;";

    dbDelta( $sql_coupons );
    dbDelta( $sql_uses );
}

/**
 * Carritos abandonados
 *
 * Fuente de verdad para el envío:
 * - email (capturado en checkout y guardado aquí)
 *
 * Nota:
 * - user_id se mantiene por compatibilidad, pero ya no es requisito.
 */
function shoplite_pro_install_abandoned_carts_table() {
    global $wpdb;

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    $charset_collate = $wpdb->get_charset_collate();

    $table_abandoned = $wpdb->prefix . 'shoplite_abandoned_carts';

    $sql_abandoned = "CREATE TABLE $table_abandoned (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        session_id VARCHAR(191) NOT NULL,
        user_id BIGINT UNSIGNED NOT NULL DEFAULT 0,
        email VARCHAR(190) NULL,
        cart_json LONGTEXT NULL,
        cart_total DECIMAL(10,2) NOT NULL DEFAULT 0,
        last_update DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        email_sent TINYINT(1) NOT NULL DEFAULT 0,
        email_sent_at DATETIME NULL,
        PRIMARY KEY (id),
        KEY session_id_idx (session_id),
        KEY user_idx (user_id),
        KEY email_idx (email),
        KEY email_sent_idx (email_sent),
        KEY last_update_idx (last_update),
        KEY email_sent_last_update_idx (email_sent, last_update)
    ) $charset_collate;";

    dbDelta( $sql_abandoned );
}

/**
 * ✅ Entregas digitales (Pro)
 */
function shoplite_pro_install_deliveries_table() {
    global $wpdb;

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    $charset_collate = $wpdb->get_charset_collate();

    $table = $wpdb->prefix . 'shoplite_deliveries';

    $sql = "CREATE TABLE $table (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        order_id BIGINT UNSIGNED NOT NULL,
        product_id BIGINT UNSIGNED NOT NULL,
        customer_email VARCHAR(190) NOT NULL,
        delivery_type VARCHAR(30) NOT NULL,
        status VARCHAR(20) NOT NULL DEFAULT 'pending',
        token VARCHAR(64) NULL,
        delivery_data LONGTEXT NULL,
        downloads_used INT UNSIGNED NOT NULL DEFAULT 0,
        downloads_limit INT UNSIGNED NULL,
        expires_at DATETIME NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (id),
        KEY order_id (order_id),
        KEY product_id (product_id),
        KEY customer_email (customer_email),
        KEY status (status),
        KEY token (token)
    ) $charset_collate;";

    dbDelta( $sql );
}

