<?php
// shoplite-pro/includes/class-shoplite-pro-abandoned-carts.php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Shoplite_Pro_Abandoned_Carts {

    const PAGE_SLUG = 'shoplite_pro_abandoned_carts';

    // Simple options (used later by the real logic)
    const OPTION_ENABLED       = 'shoplite_pro_abandoned_enabled';
    const OPTION_DELAY_MIN     = 'shoplite_pro_abandoned_delay_min';
    const OPTION_EMAIL_SUBJECT = 'shoplite_pro_abandoned_subject';
    const OPTION_EMAIL_BODY    = 'shoplite_pro_abandoned_body';

    public static function init() {
        // Settings page under "Settings"
        add_action( 'admin_menu', [ __CLASS__, 'register_settings_page' ] );

        // Submenu under "Talariasoft Shoplite" pointing to that same page
        add_action( 'admin_menu', [ __CLASS__, 'register_shoplite_submenu' ], 60 );
    }

    /**
     * Settings page in the "Settings" menu.
     * URL: wp-admin/options-general.php?page=shoplite_pro_abandoned_carts
     */
    public static function register_settings_page() {
        add_options_page(
            __( 'Abandoned carts (Shoplite Pro)', 'shoplite-pro' ),
            __( 'Abandoned carts (Shoplite Pro)', 'shoplite-pro' ),
            'manage_options',
            self::PAGE_SLUG,
            [ __CLASS__, 'render_settings_page' ]
        );
    }

    /**
     * Submenu under "Talariasoft Shoplite" that redirects to the settings page above.
     * This way the sidebar menu link works and does not point to a non-existent physical route.
     */
    public static function register_shoplite_submenu() {

        // Just in case there is an old submenu with the same slug, remove it first
        remove_submenu_page( 'shoplite', self::PAGE_SLUG );

        // Add the submenu pointing to options-general.php?page=shoplite_pro_abandoned_carts
        add_submenu_page(
            'shoplite', // parent menu (Talariasoft Shoplite)
            __( 'Abandoned carts (Pro)', 'shoplite-pro' ),
            __( 'Abandoned carts', 'shoplite-pro' ),
            'manage_options',
            'options-general.php?page=' . self::PAGE_SLUG
            // no callback: WordPress will load options-general.php and then our page
        );
    }

    /**
     * Render the settings page.
     */
    public static function render_settings_page() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'shoplite-pro' ) );
        }

        // Save settings
        if (
            isset( $_POST['shoplite_abandoned_save'] ) &&
            check_admin_referer(
                'shoplite_pro_abandoned_carts_save',
                'shoplite_pro_abandoned_carts_nonce'
            )
        ) {
            $enabled = ! empty( $_POST['shoplite_abandoned_enabled'] ) ? 1 : 0;
            $delay   = isset( $_POST['shoplite_abandoned_delay_min'] )
                ? max( 5, absint( $_POST['shoplite_abandoned_delay_min'] ) )
                : 30;

            $subject = isset( $_POST['shoplite_abandoned_subject'] )
                ? sanitize_text_field( wp_unslash( $_POST['shoplite_abandoned_subject'] ) )
                : '';
            $body    = isset( $_POST['shoplite_abandoned_body'] )
                ? wp_kses_post( wp_unslash( $_POST['shoplite_abandoned_body'] ) )
                : '';

            update_option( self::OPTION_ENABLED,       $enabled );
            update_option( self::OPTION_DELAY_MIN,     $delay );
            update_option( self::OPTION_EMAIL_SUBJECT, $subject );
            update_option( self::OPTION_EMAIL_BODY,    $body );

            echo '<div class="notice notice-success is-dismissible"><p>'
                 . esc_html__( 'Abandoned cart settings saved.', 'shoplite-pro' )
                 . '</p></div>';
        }

        // Load current values
        $enabled = (bool) get_option( self::OPTION_ENABLED, 0 );
        $delay   = (int) get_option( self::OPTION_DELAY_MIN, 30 );
        if ( $delay <= 0 ) {
            $delay = 30;
        }

        $subject = get_option(
            self::OPTION_EMAIL_SUBJECT,
            __( 'Did you forget to complete your purchase?', 'shoplite-pro' )
        );

        $body = get_option(
            self::OPTION_EMAIL_BODY,
            __( "Hello {{nombre}},\n\nWe noticed you left products in your cart and did not finish your purchase.\nIf you are still interested, you can return to your cart here:\n\n{{cart_link}}\n\nThank you!", 'shoplite-pro' )
        );
        ?>
        <div class="wrap shoplite-pro-abandoned-carts">
        <?php
        if ( function_exists( 'shoplite_render_brand_header' ) ) {
            shoplite_render_brand_header();
        }
        ?>

        <h1><?php esc_html_e( 'Abandoned carts (Pro)', 'shoplite-pro' ); ?></h1>

            <form method="post">
                <?php wp_nonce_field(
                    'shoplite_pro_abandoned_carts_save',
                    'shoplite_pro_abandoned_carts_nonce'
                ); ?>

                <table class="form-table" role="presentation">
                    <tr>
                        <th scope="row">
                            <?php esc_html_e(
                                'Enable abandoned cart emails',
                                'shoplite-pro'
                            ); ?>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" name="shoplite_abandoned_enabled" value="1"
                                    <?php checked( $enabled, true ); ?> />
                                <?php esc_html_e(
                                    'Automatically send emails when we detect an abandoned cart.',
                                    'shoplite-pro'
                                ); ?>
                            </label>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row">
                            <?php esc_html_e(
                                'Minutes before a cart is considered abandoned',
                                'shoplite-pro'
                            ); ?>
                        </th>
                        <td>
                            <input type="number" min="5" step="5"
                                   name="shoplite_abandoned_delay_min"
                                   value="<?php echo esc_attr( $delay ); ?>" />
                            <p class="description">
                                <?php esc_html_e(
                                    'Example: 60 = send the email 1 hour after the last cart activity.',
                                    'shoplite-pro'
                                ); ?>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row">
                            <?php esc_html_e( 'Email subject', 'shoplite-pro' ); ?>
                        </th>
                        <td>
                            <input type="text" class="regular-text"
                                   name="shoplite_abandoned_subject"
                                   value="<?php echo esc_attr( $subject ); ?>" />
                        </td>
                    </tr>

                    <tr>
                        <th scope="row">
                            <?php esc_html_e( 'Email body', 'shoplite-pro' ); ?>
                        </th>
                        <td>
                            <textarea name="shoplite_abandoned_body" rows="8" class="large-text code"><?php
                                echo esc_textarea( $body );
                            ?></textarea>
                            <p class="description">
                                <?php esc_html_e(
                                    'You can use tokens such as {{nombre}} and {{cart_link}} (we will fill them in automatically).',
                                    'shoplite-pro'
                                ); ?>
                            </p>
                        </td>
                    </tr>
                </table>

                <?php submit_button(
                    __( 'Save settings', 'shoplite-pro' ),
                    'primary',
                    'shoplite_abandoned_save'
                ); ?>
            </form>
        </div>
        <?php
    }
}
