(function ($) {
    $(function () {

        // If we have no data or the license is active, do nothing
        if (typeof ShopliteProLicenseData === 'undefined' || ShopliteProLicenseData.license_active) {
            return;
        }

        /**
         * Create the license modal if it doesn't exist yet.
         */
        function ensureModal() {
            if ($('#shoplite-pro-license-modal').length) {
                return;
            }

            var html = '' +
                '<div id="shoplite-pro-license-modal" class="shoplite-pro-license-backdrop" style="display:none;">' +
                '  <div class="shoplite-pro-license-modal">' +
                '    <h2 class="shoplite-pro-license-title">' +
                '      ' + (ShopliteProLicenseData.i18n && ShopliteProLicenseData.i18n.title ? ShopliteProLicenseData.i18n.title : 'Pro feature') +
                '    </h2>' +
                '    <p class="shoplite-pro-license-message">' +
                '      ' + (ShopliteProLicenseData.i18n && ShopliteProLicenseData.i18n.message ? ShopliteProLicenseData.i18n.message : 'This feature is part of Shoplite Pro. Activate your license to use it.') +
                '    </p>' +
                '    <div class="shoplite-pro-license-actions">' +
                '      <a href="' + ShopliteProLicenseData.license_url + '" class="button button-primary shoplite-pro-license-go">' +
                '        ' + (ShopliteProLicenseData.i18n && ShopliteProLicenseData.i18n.go_to_page ? ShopliteProLicenseData.i18n.go_to_page : 'Go to license page') +
                '      </a>' +
                '      <button type="button" class="button button-secondary shoplite-pro-license-close">' +
                '        ' + (ShopliteProLicenseData.i18n && ShopliteProLicenseData.i18n.maybe_later ? ShopliteProLicenseData.i18n.maybe_later : 'Maybe later') +
                '      </button>' +
                '    </div>' +
                '  </div>' +
                '</div>';

            $('body').append(html);
        }

        function openModal() {
            ensureModal();
            $('#shoplite-pro-license-modal').fadeIn(150);
        }

        function closeModal() {
            $('#shoplite-pro-license-modal').fadeOut(150);
        }

        // Intercept all elements marked as Pro
        $(document).on('click', '.shoplite-pro-need-license', function (e) {
            e.preventDefault();
            e.stopPropagation();
            openModal();
        });

        // "Maybe later" button
        $(document).on('click', '.shoplite-pro-license-close', function (e) {
            e.preventDefault();
            closeModal();
        });

        // Close when clicking outside the modal
        $(document).on('click', '#shoplite-pro-license-modal', function (e) {
            if (e.target === this) {
                closeModal();
            }
        });

        // ========= MARK SIDEBAR MENU LINKS AS PRO =========

        // Submenus that use ?page=...
        var proSlugs = [
            'shoplite_pro_dashboard',        // Dashboard (Pro)
            'shoplite_pro_sales',            // Sales reports (Pro)
            'shoplite_pro_evolution',        // Time-based evolution
            'shoplite_pro_abandoned_carts'   // Abandoned carts
        ];

        proSlugs.forEach(function (slug) {
            $("a[href*='page=" + slug + "']").addClass('shoplite-pro-need-license');
        });

        // Coupons (Pro) is a CPT: edit.php?post_type=shoplite_coupon
        $("a[href*='post_type=shoplite_coupon']").addClass('shoplite-pro-need-license');

    });
})(jQuery);
